<?php

namespace App\Http\Controllers;
use App\Movie;
use App\Season;
use App\TvSeries;
use Illuminate\Http\Request;
use Illuminate\Support\Testing\Fakes\Fake;
use Session;

class FakeViewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $movies = Movie::whereNotNull('views')->where('views', '>', 0)->orderByUniqueViews()->get();
        $season = Season::whereNotNull('views')->where('views', '>', 0)->orderByUniqueViews()->get();
        return view('admin.fakeview.index', compact('movies', 'season'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $movie = Movie::where('views', '<=', 0)->get();
        return view('admin.fakeview.create',compact('movie'));
    }
    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the request data
        $data = $this->validate($request, [
            'movie_id' => 'required|exists:movies,id', // Ensure the movie ID exists in the database
            'views' => 'required|integer|min:1',      // Ensure views is an integer and at least 1
        ]);
    
        try {
            // Find the movie by its ID
            $movie = Movie::findOrFail($request->movie_id);
    
            // Update the views column (increment by the provided value)
            $movie->increment('views', $request->views);
    
            // Flash success message
            return redirect('admin/fakeViews')->with('success', __('Views has been updated'));
            // Redirect back
            return redirect()->back();
        } catch (\Exception $e) {
            // Handle errors and flash an error message
            Session::flash('error', __('An error occurred: ') . $e->getMessage());
            return redirect()->back();
        }
    }
 
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $movies = Movie::find($id);
        //echo $movies->views;
        return view('admin.fakeview.edit', compact('movies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $movies=Movie::find($id);
        $movies->views=$request->views;
        $movies->save();
        return redirect('admin/fakeViews')->with('success', __('Views has been updated'));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // Find the fake season view by its ID
        $movie = Movie::findOrFail($id);
    
        // Empty the 'views' column
        $movie->views = 0;
    
        // Save the changes
        $movie->save();
    
        // Return a success message
        return redirect('admin/fakeViews')->with('success', __('Views has been deleted'));
    }
}
